﻿using Microscopic_Traffic_Simulator___Model.CellularTopologyObjects.GeneralParameters;
using Microscopic_Traffic_Simulator___Model.GeometricObjects;
using Microscopic_Traffic_Simulator___Model.GeometricObjects.Lanes;
using Microscopic_Traffic_Simulator___Model.GeometricObjects.Nodes;
using Microscopic_Traffic_Simulator___Model.TrafficObjects;
using System.Windows;

namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects
{
    /// <summary>
    /// Class for building cellular topology from geometric topology.
    /// </summary>
    class CellularTopologyBuilder
    {
        /// <summary>
        /// Geometric topology which the cellular topology is built from.
        /// </summary>
        private GeometricTopology geometricTopology;

        /// <summary>
        /// Reference to cellular topology parameters.
        /// </summary>
        private CellularTopologyParameters cellularTopologyParameters;

        /// <summary>
        /// Initialization of cellular topology builder.
        /// </summary>
        /// <param name="geometricTopology">Geometric topology which will be the 
        /// cellular topology build from.</param>
        /// <param name="cellularSimulationParameters">Reference to cellular topology parameters.</param>               
        internal CellularTopologyBuilder(GeometricTopology geometricTopology,
            CellularTopologyParameters cellularTopologyParameters)
        {
            this.geometricTopology = geometricTopology;
            this.cellularTopologyParameters = cellularTopologyParameters;
        }

        /// <summary>
        /// Build cellular topology.
        /// </summary>
        internal void Build()
        {
            foreach (Lane lane in geometricTopology.Lanes)
            {
                Cell previousCell = null;
                int cellCounter = 0;
                foreach (Point lanePoint in lane.LanePoints(cellularTopologyParameters.P1_CellLength))
                {
                    Cell cell = new Cell(lanePoint);
                    if (previousCell == null)
                    {
                        if (lane.StartNode.ContainsGenerator)
                        {
                            Generator generator = lane.StartNode.Generator;
                            generator.ConnectedCell = cell;
                        }
                    }
                    else
                    {
                        if (cellCounter == 100)
                        {
                            Sensor sensor = (lane.InnerNodes[0] as SensorNode).Sensor;
                            sensor.ConnectedCell = cell;
                            cell.Sensor = sensor;
                        }
                        previousCell.FollowingCell = cell;
                        cell.PreviousCell = previousCell;
                        previousCell.NormalizedDirectionVector = cell.Location - previousCell.Location;
                    }
                    previousCell = cell;
                    cellCounter++;
                }
            }
        }
    }
}
